VERSION 5.00
Begin VB.UserControl ONSV_BMKManager 
   ClientHeight    =   6645
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   14775
   ScaleHeight     =   6645
   ScaleWidth      =   14775
   Begin VB.Frame frm_detail 
      Caption         =   "Detail"
      Height          =   3225
      Left            =   195
      TabIndex        =   2
      Top             =   3045
      Width           =   10290
      Begin Project1.ArmCheckView ckv_countries 
         Height          =   2820
         Left            =   6000
         TabIndex        =   25
         Top             =   225
         Width           =   4005
         _ExtentX        =   7064
         _ExtentY        =   4974
      End
      Begin VB.Frame fra_manipulation 
         Caption         =   "#Manipulation"
         Height          =   1485
         Left            =   210
         TabIndex        =   13
         Tag             =   "frm_maintenance"
         Top             =   1635
         Width           =   5520
         Begin VB.CheckBox chk_internet 
            Alignment       =   1  'Right Justify
            Caption         =   "#Internet"
            Height          =   255
            Left            =   4140
            TabIndex        =   26
            TabStop         =   0   'False
            Tag             =   "Internet_flag"
            Top             =   1125
            Width           =   1155
         End
         Begin VB.TextBox txt_Date 
            Alignment       =   2  'Center
            Enabled         =   0   'False
            Height          =   315
            Left            =   1440
            TabIndex        =   19
            TabStop         =   0   'False
            Tag             =   "txt_Date"
            Text            =   "02/02/2001"
            Top             =   285
            Width           =   1095
         End
         Begin VB.TextBox txt_creator 
            Enabled         =   0   'False
            Height          =   315
            Left            =   3480
            TabIndex        =   18
            TabStop         =   0   'False
            Tag             =   "txt_creator"
            Text            =   "L. Cockayne"
            Top             =   285
            Width           =   1815
         End
         Begin VB.TextBox txt_lastUpd 
            Alignment       =   2  'Center
            Enabled         =   0   'False
            Height          =   315
            Left            =   1440
            TabIndex        =   17
            TabStop         =   0   'False
            Tag             =   "txt_lastUpd"
            Text            =   "02/02/2001"
            Top             =   675
            Width           =   1095
         End
         Begin VB.TextBox txt_updUser 
            Enabled         =   0   'False
            Height          =   315
            Left            =   3480
            TabIndex        =   16
            TabStop         =   0   'False
            Tag             =   "txt_updUser"
            Text            =   "L. Cockayne"
            Top             =   675
            Width           =   1815
         End
         Begin VB.TextBox txt_dropDate 
            Alignment       =   2  'Center
            Enabled         =   0   'False
            Height          =   315
            Left            =   1440
            TabIndex        =   15
            TabStop         =   0   'False
            Tag             =   "txt_dropDate"
            Text            =   "02/02/2001"
            Top             =   1050
            Width           =   1095
         End
         Begin VB.CheckBox chk_dropped 
            Caption         =   "#Dropped"
            Height          =   255
            Left            =   2655
            TabIndex        =   14
            TabStop         =   0   'False
            Tag             =   "Drop_flag"
            Top             =   1125
            Width           =   1155
         End
         Begin VB.Label lbl_labels 
            Caption         =   "#Creation date"
            Height          =   255
            Index           =   11
            Left            =   150
            TabIndex        =   24
            Tag             =   "lbl_date"
            Top             =   360
            Width           =   1410
         End
         Begin VB.Label lbl_labels 
            Caption         =   "#By"
            Height          =   255
            Index           =   12
            Left            =   2745
            TabIndex        =   23
            Tag             =   "lbl_ByUser"
            Top             =   360
            Width           =   570
         End
         Begin VB.Label lbl_labels 
            Caption         =   "#Last updade"
            Height          =   255
            Index           =   13
            Left            =   150
            TabIndex        =   22
            Tag             =   "lbl_dateUpd"
            Top             =   780
            Width           =   1530
         End
         Begin VB.Label lbl_labels 
            Caption         =   "#By"
            Height          =   255
            Index           =   14
            Left            =   2745
            TabIndex        =   21
            Tag             =   "lbl_creator"
            Top             =   780
            Width           =   690
         End
         Begin VB.Label lbl_labels 
            Caption         =   "#Drop date"
            Height          =   255
            Index           =   15
            Left            =   150
            TabIndex        =   20
            Tag             =   "lbl_dropDate"
            Top             =   1125
            Width           =   1290
         End
      End
      Begin VB.TextBox txt_marketDesc 
         Height          =   285
         Left            =   1380
         TabIndex        =   6
         Tag             =   "BMK_Desc"
         Top             =   690
         Width           =   4275
      End
      Begin VB.TextBox txt_BMK_Code 
         Height          =   285
         Left            =   1380
         TabIndex        =   5
         Tag             =   "BMK_Code"
         Top             =   315
         Width           =   945
      End
      Begin VB.TextBox txt_BMK_ShortDesc 
         Height          =   285
         Left            =   4830
         TabIndex        =   4
         Tag             =   "BMK_ShortDesc"
         Top             =   300
         Width           =   810
      End
      Begin VB.TextBox txt_BMK_order 
         Height          =   285
         Left            =   5025
         TabIndex        =   3
         Tag             =   "BMK_order"
         Top             =   1080
         Width           =   630
      End
      Begin Project1.ArmCombobox cbo_currency 
         Height          =   345
         Left            =   1380
         TabIndex        =   7
         Tag             =   "CURR_code"
         Top             =   1020
         Width           =   2865
         _ExtentX        =   5054
         _ExtentY        =   609
      End
      Begin VB.Label lbl_labels 
         Caption         =   "Code"
         Height          =   240
         Index           =   2
         Left            =   225
         TabIndex        =   12
         Top             =   330
         Width           =   735
      End
      Begin VB.Label lbl_labels 
         Caption         =   "Currency"
         Height          =   240
         Index           =   4
         Left            =   225
         TabIndex        =   11
         Top             =   1125
         Width           =   885
      End
      Begin VB.Label lbl_labels 
         Caption         =   "Market short desc"
         Height          =   240
         Index           =   3
         Left            =   3210
         TabIndex        =   10
         Top             =   330
         Width           =   1545
      End
      Begin VB.Label lbl_labels 
         Caption         =   "Market name"
         Height          =   270
         Index           =   5
         Left            =   225
         TabIndex        =   9
         Top             =   750
         Width           =   990
      End
      Begin VB.Label lbl_labels 
         Caption         =   "Order"
         Height          =   270
         Index           =   6
         Left            =   4380
         TabIndex        =   8
         Top             =   1095
         Width           =   570
      End
   End
   Begin Project1.ToolbarControl tlb_main 
      Height          =   690
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   10560
      _ExtentX        =   18627
      _ExtentY        =   1217
   End
   Begin Project1.ArmGrid grd_lst 
      Height          =   4020
      Left            =   105
      TabIndex        =   1
      Top             =   720
      Width           =   10515
      _ExtentX        =   18547
      _ExtentY        =   7091
   End
End
Attribute VB_Name = "ONSV_BMKManager"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const SCREEN_NAME As String = "ONSVBMKManager"

Private Declare Function LockWindowUpdate Lib "user32" (ByVal hwnd As Long) As Long

Private Const SEP = ""
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F

Private Const C_TOOLBARFACE_ITEM_LST As String = "0"
Private Const C_TOOLBARFACE_ITEM_UPD As String = "1"
Private Const C_TOOLBARFACE_ITEM_ADD As String = "2"
Private Const C_TOOLBARFACE_ITEM_DELETE As String = "3"
Private Const C_TOOLBARFACE_ITEM_VIEW As String = "4"


Private mb_eventRunning As Boolean
Private mb_Initialized As Boolean
Private mo_Db As ArmDb
Private ms_Language_Code As String
Dim mu_ActiveMode As ArmScreenMode
Private ml_U_Code As Long
Private ms_Login_name As String

Public Event quit()
Private Enum ArmScreenMode
  smMain
  smAdd
  smUpdate
  smDelete
  smView
End Enum

Public Property Get Initialized() As Boolean
    Initialized = mb_Initialized
End Property


Public Property Let Visible(ByVal aVisible As Boolean)
    UserControl.Extender.Visible = aVisible
End Property
Public Property Get Visible() As Boolean
    Visible = UserControl.Extender.Visible
End Property

Public Sub Move(ByVal aLeft As Single, ByVal aTop As Single, ByVal aWidth As Single, ByVal aHeight As Single)
    Call UserControl.Extender.Move(aLeft, aTop, aWidth, aHeight - 2220)
    Call Resize
End Sub

Property Let Language_Code(AString As String)
On Error GoTo ErrHandler

  ms_Language_Code = AString
  Exit Property
ErrHandler:
  Call ErrorMessage("Language_Code.Let")
End Property

Private Function GetLoginName(ByVal al_U_Code As Long) As String
On Error GoTo ErrHandler
    
    Dim ll_Cursor As Long
    ll_Cursor = OpenSQLSafe(mo_Db, "SELECT U_Login_name from [gen_systems_users] where U_Code=" & al_U_Code)
    
    GetLoginName = mo_Db.GetFields(ll_Cursor, "U_Login_name")
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    Exit Function
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
  Call ErrorHandler("GetLoginName.Let")
End Function

Property Let U_Code(ByVal al_U_Code As Long)
On Error GoTo ErrHandler

  ml_U_Code = al_U_Code
  Exit Property
ErrHandler:
  Call ErrorMessage("U_Code.Let")
End Property

Public Property Set ArmDb(ByRef lo_Db As Object)
On Error GoTo ErrHandler
  
  Set mo_Db = lo_Db
  Exit Property
ErrHandler:
  Call ErrorHandler("ArmDb.Set")
End Property


Public Sub Resize()
    Call InitCtrlSize
End Sub

Private Sub InitCtrlSize()
On Error GoTo ErrHandler
    If UserControl.Extender.Width < 11910 Then
        Exit Sub
    End If
    
    If UserControl.Extender.Height < 3500 Then
        Exit Sub
    End If
    
    Const SPACE As Long = 60
    Call tlb_Main.Move(SPACE, 0, UserControl.Extender.Width - 2 * SPACE - 30, tlb_Main.Height)
    
    Call grd_lst.Move(tlb_Main.Left, tlb_Main.Top + tlb_Main.Height, tlb_Main.Width, UserControl.Extender.Height - 2 * SPACE - tlb_Main.Height)
    
    Call frm_detail.Move(grd_lst.Left, grd_lst.Top, grd_lst.Width, grd_lst.Height)
    
    ckv_countries.Width = frm_detail.Width - ckv_countries.Left - SPACE
    
    ckv_countries.Height = frm_detail.Height - ckv_countries.Top - SPACE
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("InitCtrlSize")
End Sub

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
    Err.Raise Err.Number, UserControl.Name & "." & UserControl.Ambient.DisplayName & "::" & as_Fct & SEP1 & Err.Source, Err.Description
End Sub

Public Sub Load_A_COM()
    
On Error GoTo ErrHandler

    If mb_Initialized Then Exit Sub
    
    mb_Initialized = True
    
    mb_eventRunning = True
    
    Dim lo_Control As Object
    Dim lo_ToolTip As Object
    
      For Each lo_Control In Controls
        Select Case UCase(TypeName(lo_Control))
        Case "ARMCOMBOBOX"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "ARMPICKER"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "TOOLBARCONTROL"
          lo_Control.Language = ms_Language_Code
'          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "ARMGRID"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "ARMTREEVIEW"
          Set lo_Control.ArmDb = mo_Db
          lo_Control.Language = ms_Language_Code
          Call lo_Control.Load_A_COM
        Case "ARMCHECKVIEW"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        Case "A_CALOCX"
          lo_Control.Language = ms_Language_Code
          Call lo_Control.reinit_cal
        Case "TOOLBR"
          Set lo_Control.ArmDb = mo_Db
          Call lo_Control.Load_A_COM
        End Select
      Next
      
      ms_Login_name = GetLoginName(ml_U_Code)
    
    ' init toolbar
'336EESFGIDRW05858QE/BACCVVDGGEFFJTT
    Call tlb_Main.SetToolbarInfoStringParameters("001EESFGIDRW011708QE/BACAAABBBCCCHLLTTT111708QE/BACAHHBIITTT211708QE/BACAHHBIIGJJHKKTTT311708QE/BACAHHTTT411708QE/BACBBBCCCTTT", "001")
    
    ' init grig
    grd_lst.AllowExcelExport = True
    grd_lst.Title = "NSV values"
    grd_lst.MultiSelect = False
    
    
    If Not grd_lst.SetColumns(Array( _
                Join(Array("BMK_CODE", 0, 1, "BMK_code", "#BMK_code"), SEP) _
                , Join(Array("BMK_DESC", 2500, 0, "BMK_desc", "Name"), SEP) _
                , Join(Array("CURR_CODE", 0, 0, "CURR_code", "CURR_code"), SEP) _
                , Join(Array("CURR_DESC", 2900, 0, "CURR_desc", "Currency"), SEP) _
                , Join(Array("BMK_SHORTDESC", 700, 0, "BMK_ShortDesc", "Short Desc"), SEP) _
                , Join(Array("BMK_ORDER", 700, 0, "BMK_order", "order", "int"), SEP) _
                , Join(Array("INTERNET_FLAG", 700, 0, "internet_flag", "Internet"), SEP) _
                , Join(Array("DROP_FLAG", 700, 0, "drop_flag", "drop flag"), SEP) _
                )) Then
        MsgBox ("Grid not initialized!")
    End If
    
    cbo_currency.FirstBlankItem = False
    cbo_currency.Request = "SELECT CURR_code, CURR_desc FROM [Currencies] WHERE LANGUAGE_CODE='" & ms_Language_Code & "' ORDER BY CURR_desc"
    
    ckv_countries.Driven_By = "Market"
    ckv_countries.Common_List_Load = True
    ckv_countries.Type_Of_Key = tkDependant
    ckv_countries.Calling_Key_Fields = "BMK_Code"
    ckv_countries.Calling_Key_Values = "S009"
    ckv_countries.Link_Key_Fields = "CT_Code"
    ckv_countries.ComboVisible = False
    
    Dim lv_RoleList As Variant
    
    ckv_countries.RoleCount = 2
    ReDim lv_RoleList(1)
    lv_RoleList(0) = Array("MAIN", _
                            "VIEW", _
                            "", _
                            "", _
                            "Main view", _
                            "CT_CodeCT_Desc", _
                            "CT_Desc", _
                            "2700", _
                            "CT_Code", _
                            "exec Countries_BM_lst '$BMK_Code$', '" & ms_Language_Code & "'", _
                            "", _
                            "", _
                            True, _
                            2, _
                            False, _
                            True, _
                            0, _
                            0)
                            
    lv_RoleList(1) = Array("EDIT", _
                            "EDIT", _
                            "", _
                            "", _
                            "EDIT", _
                            "CT_CodeCT_Desc", _
                            "CT_Desc", _
                            "2700", _
                            "CT_Code", _
                            "exec Countries_BM_lst2 '$BMK_Code$', '" & ms_Language_Code & "'", _
                            "exec Countries_BM_ins '$BMK_Code$', '$CT_Code$','" & ms_Login_name & "'", _
                            "exec Countries_BM_del '$BMK_Code$', '$CT_Code$'", _
                            False, _
                            2, _
                            False, _
                            True, _
                            0, _
                            0)
    If Not ckv_countries.SetRoleList(lv_RoleList) Then
        Err.Raise 1, "ckv_Countries.SetRoleList", "Setting CheckView parameters failed."
    End If
        
    ' update view when edit check list changed by user
    ckv_countries.Synchronize_View = True

    Call UpdateUI(ArmScreenMode.smMain)
    
    Call RefreshGrid
    
    mb_eventRunning = False
    
    Exit Sub
    
ErrHandler:
    Call ErrorHandler("Load_A_COM")
End Sub



Private Sub UpdateUI(ByVal au_Mode As ArmScreenMode)
On Error GoTo ErrHandler

    ' set active face
    mu_ActiveMode = au_Mode
    tlb_Main.Redraw = False
    

    ' apply face
    Dim lo_ctrl As Object

    ' hide all frames
    frm_detail.Visible = False
    grd_lst.Visible = False

    ' we have clean screen we can display proper controls
    Select Case mu_ActiveMode
        Case smMain
            grd_lst.Visible = True
            Call EnableControl(grd_lst, True)
            Call SetEnabled(GetContainedControlsChain(frm_detail), False)
    
            Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_LST)
        Case smUpdate
            ' we are in Update section
            frm_detail.Visible = True
            Call EnableControl(grd_lst, False)
            Call SetEnabled(GetContainedControlsChain(frm_detail), True)
            Call EnableControl(txt_BMK_Code, False)
            
            Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_UPD)
            
            Call ckv_countries.SetVisibleList("EDIT")
        Case smAdd
            ' we are in Update section
            frm_detail.Visible = True
            Call EnableControl(grd_lst, False)
            Call SetEnabled(GetContainedControlsChain(frm_detail), True)
            
            Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_ADD)
        
            Call ckv_countries.SetVisibleList("EDIT")
        Case smView
            ' we are in PreView section
            frm_detail.Visible = True
            Call EnableControl(grd_lst, False)
            Call SetEnabled(GetContainedControlsChain(frm_detail), False)
            
            Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_VIEW)
            
            Call ckv_countries.SetVisibleList("MAIN")
        Case smDelete
            ' we are in PreView section
            frm_detail.Visible = True
            Call EnableControl(grd_lst, False)
            Call SetEnabled(GetContainedControlsChain(frm_detail), False)
            
            Call tlb_Main.DisplayFace(C_TOOLBARFACE_ITEM_DELETE)
            
            Call ckv_countries.SetVisibleList("MAIN")
        Case Else
            Debug.Assert (False)
    End Select
    
    ' to display face immidiatelly
    tlb_Main.Redraw = True
    UserControl.Refresh
    Exit Sub
ErrHandler:
    Call ErrorHandler("UpdateUI()")
End Sub


Private Sub RefreshGrid()
On Error GoTo ErrHandler
    Const REQ As String = "EXEC Business_Market2_lst $LANG$"
    Dim ls_req As String
    
    ls_req = Replace(REQ, "$LANG$", SqlStr(ms_Language_Code, 1), , , vbTextCompare)
    
    If Not grd_lst.Load(ls_req, True) Then
        MsgBox ("Grid not loaded (Business_Market2_lst)!")
    End If
    
    Call Item_Clear
    
    Exit Sub
ErrHandler:
     Call ErrorHandler("RefreshGrid()")
End Sub


Private Function GetContainedControlsChain(ByVal ao_parent As Object) As Collection
On Error GoTo ErrHandler
    Dim lo_retCollection As New Collection
    Dim lo_Control As Object
    
    For Each lo_Control In Controls
        If Not TypeOf lo_Control Is CommonDialog Then
            If Not TypeOf lo_Control.Container Is ONSV_BMKManager Then
                If ao_parent.hwnd = lo_Control.Container.hwnd Then
                    If TypeOf lo_Control Is Frame Then
                        Dim lo_aux_collection As New Collection
                        Dim ll_i As Long
                        Set lo_aux_collection = GetContainedControlsChain(lo_Control)
                        For ll_i = 1 To lo_aux_collection.Count
                            lo_retCollection.Add (lo_aux_collection.Item(ll_i))
                        Next
                    Else
                        Call lo_retCollection.Add(lo_Control)
                    End If
                End If
            End If
        End If
    Next
    Set GetContainedControlsChain = lo_retCollection
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".GetContainedControlsChain()")
End Function


Private Sub grd_lst_DblClick()
On Error GoTo ErrHandler
    If grd_lst.SelectedCount = 0 Then Exit Sub
    mb_eventRunning = True
    
    Call LockScreen(True)
    
    Call Item_ViewInit(grd_lst.SelectedKey(0))
    
    Call LockScreen(False)
    mb_eventRunning = False
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    mb_eventRunning = False
    Call ErrorMessage("grd_lst_DblClick")
End Sub

Private Sub tlb_Main_action(ByVal as_Role As String, as_Language As String)
On Error GoTo ErrHandler
    Call LockScreen(True)
    mb_eventRunning = True

    Select Case as_Role
    Case "A"
        Call Item_AddInit
    Case "B"       ' Update, refresh detail
        If grd_lst.SelectedCount = 1 Then
            Call Item_UpdateInit(grd_lst.SelectedKey(0))
        Else
            Call MsgBox(MsgText(9214, ms_Language_Code, "#Please, select single row"))
        End If
    Case "C"
        If grd_lst.SelectedCount = 1 Then
            Call Item_DeleteInit(grd_lst.SelectedKey(0))
        Else
            Call MsgBox(MsgText(9214, ms_Language_Code, "#Please, select single row"))
        End If
    Case "I"              ' reset changes
        Select Case mu_ActiveMode
        Case smAdd
            Call Item_AddInit
        Case smUpdate
            Debug.Assert (grd_lst.SelectedCount = 1)
            Call Item_UpdateInit(grd_lst.SelectedKey(0))
        End Select
    Case "L"        ' refresh grid
        Call RefreshGrid
    Case "H"
        Select Case mu_ActiveMode
        Case smAdd
            Call Item_Add
        Case smUpdate
            Call Item_Update
        Case smDelete
            Call Item_Delete
        End Select
    Case "T"              ' QUIT
        If mu_ActiveMode = smMain Then
            RaiseEvent quit
        Else
            Call UpdateUI(smMain)
        End If
        
    End Select

    Call LockScreen(False)
    mb_eventRunning = False
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    mb_eventRunning = False
    Call ErrorMessage("tlb_main_action")
End Sub


Private Sub Item_Add()
On Error GoTo ErrHandler
Const C_REQ As String = "EXEC Business_Market2_chk $BMK_CODE$"
    If Not Item_Check Then
        Exit Sub
    End If

    Dim ll_Cursor As Long
    
    ll_Cursor = OpenSQLSafe(mo_Db, ReplacePlaceholders(C_REQ))
    
    If mo_Db.GetFields(ll_Cursor, "GRPCount") > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
        Call MsgBox(MsgText(666, ms_Language_Code, "Record already exists in database."), , vbInformation)
        Exit Sub
    End If
    
    Call mo_Db.Close(ll_Cursor)
    ll_Cursor = 0
    
    Call Item_AddDB
    
    Call UpdateUI(smMain)
    
    Call UpdateGridAfterAction(grd_lst, "Add", Array(txt_BMK_Code.Text))
    Exit Sub
ErrHandler:
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
        ll_Cursor = 0
    End If
    Call ErrorHandler(Extender.Name & ".Item_Add")
End Sub

Private Sub Item_Update()
On Error GoTo ErrHandler
    If Not Item_Check Then
        Exit Sub
    End If
    
    Call Item_UpdateDB
    
    Call UpdateUI(smMain)
    
    Call UpdateGridAfterAction(grd_lst, "Upd", Array(txt_BMK_Code.Text))
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Update")
End Sub

Private Sub Item_Delete()
On Error GoTo ErrHandler
    If Not Item_Check Then
        Exit Sub
    End If
    
    Call Item_DeleteDB
    
    Call UpdateUI(smMain)
    
    Call UpdateGridAfterAction(grd_lst, "Del", Array(txt_BMK_Code.Text))
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_Delete")
End Sub

Private Sub Item_AddDB()
On Error GoTo ErrHandler
    Const C_REQ As String = "EXEC Business_Market2_ins $BMK_CODE$, $BMK_DESC$, $BMK_ShortDesc$, $BMK_order$, $CURR_code$, $INTERNET_FLAG$, $Z_Creator$, $DROP_FLAG$, $DROP_DATE$"
    
    Call ExecuteSQLSafe(mo_Db, ReplacePlaceholders(C_REQ))
        
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_AddDB")
End Sub

Private Sub Item_UpdateDB()
On Error GoTo ErrHandler
    Const C_REQ As String = "EXEC Business_Market2_upd $BMK_CODE$, $BMK_DESC$, $BMK_ShortDesc$, $BMK_order$, $CURR_code$, $INTERNET_FLAG$, $Z_Last_Upd_User$, $LANG$"
    
    Call ExecuteSQLSafe(mo_Db, Replace(ReplacePlaceholders(C_REQ), "$LANG$", SqlStr(ms_Language_Code, 1), , , vbTextCompare))
        
    ' save changed countries
    If ckv_countries.SaveList = False Then
        Err.Raise (1)
    End If
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_UpdateDB")
End Sub

Private Sub Item_DeleteDB()
On Error GoTo ErrHandler
    Const C_REQ As String = "EXEC Business_Market2_del $BMK_CODE$, $Z_Last_Upd_User$"
    
    Call ExecuteSQLSafe(mo_Db, ReplacePlaceholders(C_REQ))
        
    ' save changed countries
    If ckv_countries.SaveList = False Then
        Err.Raise (1)
    End If
    
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_DeleteDB")
End Sub

Private Function ReplacePlaceholders(ByVal as_req As String) As String
On Error GoTo ErrHandler

    as_req = Replace(as_req, "$BMK_CODE$", SqlStr(txt_BMK_Code.Text, 4), , , vbTextCompare)
    as_req = Replace(as_req, "$BMK_DESC$", SqlStr(txt_marketDesc.Text, 80), , , vbTextCompare)
    as_req = Replace(as_req, "$CURR_code$", SqlStr(GetCboKey(cbo_currency), 5), , , vbTextCompare)
    as_req = Replace(as_req, "$BMK_ShortDesc$", SqlStr(txt_BMK_ShortDesc.Text, 3), , , vbTextCompare)
    as_req = Replace(as_req, "$BMK_order$", SQLNum(txt_BMK_order.Text), , , vbTextCompare)

    as_req = Replace(as_req, "$Z_Creator$", SqlStr(Txt_Creator.Text, 15), , , vbTextCompare)
    as_req = Replace(as_req, "$Z_Last_Upd_User$", SqlStr(txt_updUser.Text, 15), , , vbTextCompare)
    as_req = Replace(as_req, "$DROP_FLAG$", SqlStr(IIf(chk_dropped.Value, "X", ""), 1), , , vbTextCompare)
    as_req = Replace(as_req, "$INTERNET_FLAG$", SqlStr(IIf(chk_internet.Value, "X", ""), 1), , , vbTextCompare)
    
    as_req = Replace(as_req, "$Z_Creation$", SqlDate(txt_Date.Text), , , vbTextCompare)
    as_req = Replace(as_req, "$Z_LastUpd$", SqlDate(txt_lastUpd.Text), , , vbTextCompare)
    as_req = Replace(as_req, "$DROP_DATE$", SqlDate(txt_dropDate.Text), , , vbTextCompare)

    ReplacePlaceholders = as_req
    Exit Function
ErrHandler:
    Call ErrorHandler(Extender.Name & ".ReplacePlaceholders")
End Function

' loads values from cursor into form. if cursor=0 then reset whole detail
Private Sub Item_LoadValues(ByVal av_Key As Variant)
On Error GoTo ErrHandler

    mb_eventRunning = True
    If Not IsEmpty(av_Key) Then
        Debug.Assert (IsArray(av_Key))
        
        Const C_REQ As String = "EXEC Business_Market2_sel $BMK_CODE$, $LANG$"
        Dim ls_req As String
        Dim ll_Cursor As Long
        
        ls_req = Replace(C_REQ, "$BMK_CODE$", SqlStr(av_Key(0), 4), , , vbTextCompare)
        ls_req = Replace(ls_req, "$LANG$", SqlStr(ms_Language_Code, 1), , , vbTextCompare)
        
        ll_Cursor = OpenSQLSafe(mo_Db, ls_req, 1)
        
        Call SetComboBoxText(cbo_currency, mo_Db.GetFields(ll_Cursor, "CURR_Code"), mo_Db.GetFields(ll_Cursor, "CURR_Desc"))
        
        txt_BMK_Code.Text = av_Key(0)
        txt_BMK_ShortDesc.Text = mo_Db.GetFields(ll_Cursor, "BMK_ShortDesc")
        txt_marketDesc.Text = mo_Db.GetFields(ll_Cursor, "BMK_desc")
        txt_BMK_order.Text = mo_Db.GetFields(ll_Cursor, "BMK_order")
        
        If mo_Db.GetFields(ll_Cursor, "Z_Creation") <> 0 Then
            txt_Date.Text = Format(mo_Db.GetFields(ll_Cursor, "Z_Creation"), "dd\/mm\/yyyy")
        End If
        Txt_Creator.Text = ""
        If mo_Db.GetFields(ll_Cursor, "Z_last_upd") <> 0 Then
            txt_lastUpd.Text = Format(mo_Db.GetFields(ll_Cursor, "Z_last_upd"), "dd\/mm\/yyyy")
        End If
        txt_updUser.Text = mo_Db.GetFields(ll_Cursor, "Z_last_upd_user")
        If mo_Db.GetFields(ll_Cursor, "drop_date") <> 0 Then
            txt_dropDate.Text = Format(mo_Db.GetFields(ll_Cursor, "drop_date"), "dd\/mm\/yyyy")
        End If
        chk_dropped.Value = IIf(mo_Db.GetFields(ll_Cursor, "drop_flag") = "X", vbChecked, vbUnchecked)
        chk_internet.Value = IIf(mo_Db.GetFields(ll_Cursor, "internet_flag") = "X", vbChecked, vbUnchecked)
        
        ckv_countries.Calling_Key_Values = av_Key(0)
        ckv_countries.LoadEditLists
        
        ckv_countries.LoadList
    Else
        ' load default values
        txt_BMK_Code.Text = "NEW"
        
        txt_Date.Text = Format(Now, "dd\/mm\/yyyy")
        Txt_Creator.Text = ms_Login_name
        txt_lastUpd.Text = Format(Now, "dd\/mm\/yyyy")
        txt_updUser.Text = ms_Login_name
        
        ckv_countries.Calling_Key_Values = ""
        
        ckv_countries.LoadEditLists
        ckv_countries.LoadList
    End If
    
    mb_eventRunning = False

    Exit Sub
ErrHandler:
    mb_eventRunning = False
    Call ErrorHandler(Extender.Name & ".Item_LoadValues")
End Sub

Private Sub Item_AddInit()
On Error GoTo ErrHandler
    
    Call Item_Clear
    
    ' loading values
    Call Item_LoadValues(Empty)
    
    Call UpdateUI(ArmScreenMode.smAdd)
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_AddInit")
End Sub
Private Sub Item_DeleteInit(ByVal as_detailKey As Variant)
On Error GoTo ErrHandler
    
    Call Item_Clear
    
    ' loading values
    Call Item_LoadValues(as_detailKey)
    
    Call UpdateUI(ArmScreenMode.smDelete)
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_DeleteInit")
End Sub

Private Sub Item_ViewInit(ByVal as_detailKey As Variant)
On Error GoTo ErrHandler
    
    Call Item_Clear
    
    ' loading values
    Call Item_LoadValues(as_detailKey)
    
    Call UpdateUI(ArmScreenMode.smView)
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_ViewInit")
End Sub

Private Sub Item_UpdateInit(ByVal as_detailKey As Variant)
On Error GoTo ErrHandler
    
    Call Item_Clear
    
    ' loading values
    Call Item_LoadValues(as_detailKey)
    
    Call UpdateUI(ArmScreenMode.smUpdate)
    Exit Sub
ErrHandler:
    Call ErrorHandler(Extender.Name & ".Item_UpdateInit")
End Sub

Private Function Item_Check() As Boolean
On Error GoTo ErrHandler
    Item_Check = False

    If Not isNumeric(txt_BMK_order.Text) Then
        Call MsgBox("Wrong Market order number!")
        Call txt_BMK_order.SetFocus
        Exit Function
    End If
    
    If Trim(txt_BMK_Code.Text) = "" Or txt_BMK_Code.Text = "NEW" Then
        Call MsgBox("Wrong Market code!")
        Call txt_BMK_Code.SetFocus
        Exit Function
    End If

    If Trim(txt_marketDesc.Text) = "" Then
        Call MsgBox("Wrong Market name!")
        Call txt_marketDesc.SetFocus
        Exit Function
    End If

    If Trim(txt_BMK_ShortDesc.Text) = "" Then
        Call MsgBox("Wrong Short Market name!")
        Call txt_BMK_ShortDesc.SetFocus
        Exit Function
    End If

    If GetCboKey(cbo_currency) = "" Then
        Call MsgBox("Missing Currency!")
        Call cbo_currency.SetFocus
        Exit Function
    End If
    
    Item_Check = True
    Exit Function
ErrHandler:
    Call ErrorMessage("Item_Check")
End Function


Private Sub Item_Clear()
On Error GoTo ErrHandler
    Dim lo_Control As Control
    For Each lo_Control In Controls
        If lo_Control.Tag <> "" Then
            Select Case UCase(TypeName(lo_Control))
            Case "ARMCOMBOBOX"
                Set lo_Control.SelectedItem = Nothing
            Case "ARMPICKER"
            Case "TOOLBARCONTROL"
            Case "ARMGRID"
            Case "ARMTREEVIEW"
            Case "ARMCHECKVIEW"
                lo_Control.Init
            Case "A_CALOCX"
                lo_Control.reinit_cal
            Case "TOOLBR"
            Case "TEXTBOX"
                lo_Control.Text = ""
            Case "CHECKBOX"
                lo_Control.Value = vbUnchecked
            End Select
        End If
    Next
    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_Clear()")
End Sub


Public Sub Unload_A_COM()
    
On Error GoTo ErrHandler
    mb_Initialized = False
    
    Dim lo_Control As Object

    For Each lo_Control In Controls
      Select Case UCase(TypeName(lo_Control))
      Case "ARMCOMBOBOX"
        Call lo_Control.Unload_A_COM
      Case "ARMPICKER"
        Call lo_Control.Unload_A_COM
      Case "TOOLBARCONTROL"
        Call lo_Control.Unload_A_COM
      Case "ARMGRID"
        Call lo_Control.Unload_A_COM
      Case "ARMTREEVIEW"
        Call lo_Control.Unload_A_COM
      Case "ARMCHECKVIEW"
        Call lo_Control.Unload_A_COM
      Case "TOOLBR"
        Call lo_Control.Unload_A_COM
      End Select
    Next
    Exit Sub
    
ErrHandler:
    
    Call ErrorHandler("UnLoad_A_Com")
    
End Sub

Private Sub UpdateGridAfterAction(ByVal ao_grid As ArmGrid, ByVal as_Action As String, ByVal av_Key As Variant)
On Error GoTo ErrHandler
    Dim ll_Index As Long
    Dim lo_Column As ArmColumn
    
    Select Case as_Action
    Case "Add"
        ' insert row at the end of grid
        Debug.Assert (ao_grid.Cols > 0)
        Dim lsa_newRow() As String
        'MS REDIMM
        Call SafeRedimPreserve(lsa_newRow, ao_grid.Cols - 1)
        Dim ll_KeyIndex As Long
        ll_KeyIndex = 0
        
        For ll_Index = 0 To ao_grid.Cols - 1
            Set lo_Column = ao_grid.Columns(ll_Index)
            If lo_Column.Key Then
                Debug.Assert (UBound(av_Key) >= ll_KeyIndex)
                lsa_newRow(ll_Index) = av_Key(ll_KeyIndex)
                ll_KeyIndex = ll_KeyIndex + 1
            Else
                lsa_newRow(ll_Index) = GetDataSrcForGrid(lo_Column)
            End If
        Next
        Call ao_grid.AddLine(lsa_newRow)
    Case "Upd"
        ' search and update row in the grid
        Debug.Assert (ao_grid.Cols > 0)
        
        If Not ao_grid.SearchKey(True, av_Key) Then
            Call Err.Raise(1, "ao_grid.SearchKey", "Cannot update grid.")
        End If
        
        For ll_Index = 0 To ao_grid.Cols - 1
            Set lo_Column = ao_grid.Columns(ll_Index)
            If Not lo_Column.Key Then
                If Not lo_Column.SetData(ao_grid.Row, GetDataSrcForGrid(lo_Column)) Then
                    Call Err.Raise(1, "lo_Column.SetData", "Cannot update grid.")
                End If
            End If
        Next
    Case "Del"
        ' remove row from grid
        If Not ao_grid.DeleteLine(av_Key) Then
            Call Err.Raise(1, "DeleteLine", "Cannot delete line.")
        End If
    Case Else
        Debug.Assert (False)
    End Select
    Exit Sub
ErrHandler:
     Call ErrorHandler("UpdateGridAfterAction()")
End Sub

' when updating main grid from detail
Private Function GetDataSrcForGrid(ByVal ao_Column As ArmColumn) As String
On Error GoTo ErrHandler
    Select Case ao_Column.FieldName
        Case "CURR_code"
            GetDataSrcForGrid = GetCboKey(cbo_currency)
        Case "CURR_desc"
            GetDataSrcForGrid = GetCboText(cbo_currency)
        Case "BMK_desc"
            GetDataSrcForGrid = txt_marketDesc.Text
        Case "BMK_code"
            GetDataSrcForGrid = txt_BMK_Code.Text
        Case "BMK_order"
            GetDataSrcForGrid = txt_BMK_order.Text
        Case "BMK_ShortDesc"
            GetDataSrcForGrid = txt_BMK_ShortDesc.Text
        Case "drop_flag"
            GetDataSrcForGrid = IIf(chk_dropped.Value, "X", "")
        Case "internet_flag"
            GetDataSrcForGrid = IIf(chk_internet.Value, "X", "")
    End Select
    
    Exit Function
ErrHandler:
     Call ErrorHandler("GetDataSrcForGrid()")
End Function



'*********************************** support functions ******************************************
' display standard error message
Private Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    Dim ls_Message As String
    
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    ls_Message = SCREEN_NAME & " exception. Nr:" & Err.Number & ",Desc: " & ls_errDescription & ",Src:" & ls_ErrSource & "@"
'    Call mo_Tools.LogMessage(mo_Db, ml_U_Code, SCREEN_NAME, ls_Message, "E")
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    End
End Sub

Private Sub EnableControl(ByVal ao_Control As Control, ByVal ab_Enabled As Boolean)
On Error GoTo ErrHandler

    Select Case UCase(TypeName(ao_Control))
        Case "FRAME", "LABEL", "MSFLEXGRID", "SHAPE", "ARMGRID", "ARMCHECKVIEW", "TABSTRIP"
            ao_Control.Enabled = ab_Enabled
            ' Do nothing !
        Case "LISTVIEW"
            ' Do nothing !
        Case "TEXTBOX"
            ao_Control.Locked = Not ab_Enabled
            ao_Control.BackColor = IIf(ab_Enabled, CL_COLOR_ENABLED, CL_COLOR_DISABLED)
            ao_Control.TabStop = ab_Enabled
        Case "OPTIONBUTTON"
            ao_Control.Enabled = ab_Enabled
        Case "ARMCOMBOBOX", "A_CALOCX", "OPTIONBUTTON", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "CHECKBOX", "COMMANDBUTTON", "TOOLBARCONTROL"
            ao_Control.Enabled = ab_Enabled
            ao_Control.TabStop = ab_Enabled
        Case Else
          Debug.Print ao_Control.Name
    End Select
  Exit Sub
ErrHandler:
  Call ErrorHandler("EnableControl")
End Sub

Private Sub SetEnabled(ByVal ao_srcCtrl As Object, ByVal ab_Value As Boolean)
On Error GoTo ErrHandler
    Dim lo_ctrl As Object
    For Each lo_ctrl In ao_srcCtrl
        Call EnableControl(lo_ctrl, ab_Value)
    Next
    Exit Sub
ErrHandler:
     Call ErrorHandler("SetEnabled()")
End Sub


' translate string to sql format
' Params:
' as_Value (String)
' ab_EmptyNULL (Boolean = False)
Private Function SqlStr(ByVal as_Value As String, Optional ByVal al_MaxLen As Long = 8000, Optional ByVal ab_EmptyNULL As Boolean = False) As String
    If as_Value = "" And ab_EmptyNULL Then
        SqlStr = "NULL"
    Else
        SqlStr = "'" & Replace(Left(as_Value, IIf(Len(as_Value) <= al_MaxLen, Len(as_Value), al_MaxLen)), "'", "''") & "'"
    End If
End Function

Private Function SqlDate(ByVal av_Data As String) As String
On Error GoTo ErrHandler

    SqlDate = "NULL"
    If IsNull(av_Data) Then av_Data = ""
    If (Trim(CStr(av_Data)) <> "") And (CStr(av_Data) <> "0") Then
        SqlDate = "'" & Format(av_Data, "yyyy-mm-dd") & "'"
    End If
    Exit Function
ErrHandler:
End Function


Private Function SQLNum(ByVal as_str As String) As String
    SQLNum = Replace(as_str, ",", ".")
End Function

Private Function GetCboKey(ByRef ao_cbo As ArmCombobox) As String
On Error GoTo ErrHandler
    GetCboKey = ""
    If Not ao_cbo.SelectedItem Is Nothing Then
        GetCboKey = ao_cbo.SelectedItem.Key
    End If
    Exit Function
ErrHandler:
     Call ErrorHandler("GetCboKey()")
End Function

Private Function GetCboText(ByRef ao_cbo As ArmCombobox) As String
On Error GoTo ErrHandler
    GetCboText = ""
    If Not ao_cbo.SelectedItem Is Nothing Then
        GetCboText = ao_cbo.SelectedItem.DisplayText
    End If
    Exit Function
ErrHandler:
     Call ErrorHandler("GetCboText()")
End Function

' Sets combobox selected item
' Params:
' ao_ComboBox (ArmCombobox)
' as_Key (String)
' as_Desc (String)
Private Sub SetComboBoxText(ByRef ao_Combobox As ArmCombobox, ByVal as_Key As String, ByVal as_desc As String)
On Error GoTo ErrHandler
    If Not ao_Combobox.SearchItem(as_Key) Then
        ' key not found ... set value from parameter
        If as_Key = "" Or as_Key = "0" Then     ' zero or empty string is not valid key
            Set ao_Combobox.SelectedItem = Nothing
        Else
            Call ao_Combobox.AddItem(Array(as_Key, as_desc), True)
            ' to make vb raise event
            Call ao_Combobox.SearchItem(as_Key)
        End If
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler("SetComboBoxText")
End Sub

Private Sub LockScreen(ByVal ab_lock As Boolean)

    Dim ll_errNumber As Long, ls_ErrSrc As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSrc = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo ErrHandler
    Static ll_Count As Long
    Static ll_Mousepointer As Long
    Static lb_Locked As Boolean
      
      
    ll_Count = ll_Count + IIf(ab_lock, 1, -1)
    Debug.Assert (ll_Count >= 0)
    
    ' First lock
    If Not lb_Locked And ab_lock Then
        ll_Mousepointer = Screen.MousePointer
        Screen.MousePointer = vbHourglass
        LockWindowUpdate UserControl.hwnd
        lb_Locked = True
    End If
    
    ' Unlock
    If ll_Count = 0 Then
        DoEvents ' Flush events
        LockWindowUpdate 0
        UserControl.Refresh
        Screen.MousePointer = ll_Mousepointer
        lb_Locked = False
    End If
    
    Err.Number = ll_errNumber
    Err.Source = ls_ErrSrc
    Err.Description = ls_ErrDesc
    
    Exit Sub
    
ErrHandler:
    Call ErrorHandler("LockScreen")
End Sub

Private Function OpenSQLSafe(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
On Error GoTo ErrHandler
    Dim lc_Data As Long
    lc_Data = ao_Db.OpenSQL(as_Request)
    If lc_Data = 0 Then
        Call Err.Raise(1, "ao_Db.OpenSQL - " & "SQL : " & as_Request, "SQL Error: " & GetDbError(ao_Db))
    End If
    
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_Db.RowCount(lc_Data) <> al_RowExpectedCount Then
            Call Err.Raise(2, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_Db.RowCount(lc_Data))
        End If
    End If
    OpenSQLSafe = lc_Data
    Exit Function
ErrHandler:
    Call ErrorHandler("OpenSQLSafe")
End Function

Private Sub ExecuteSQLSafe(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
On Error GoTo ErrHandler

    ' First execute the request
    If Not ao_Db.ExecuteSQL(as_Request) Then
        If GetArrayValue(ao_Db.SQLErrorCodes, 0) = 547 Then
            Err.Raise 3, "SQL : " & as_Request, Join(ao_Db.SQLErrorCodes, SEP2) & SEP1 & Join(ao_Db.SQLErrorMessages, SEP2)
        End If
        Err.Raise 1, "SQL : " & as_Request, Join(ao_Db.SQLErrorCodes, SEP2) & SEP1 & Join(ao_Db.SQLErrorMessages, SEP2)
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_Db.SQLRowsAffected <> al_RowAffectedCount Then
            
            If ab_DuplicityCheck Then
                Err.Raise 4, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_Db.SQLRowsAffected
            Else
                Err.Raise 5, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_Db.SQLRowsAffected
            End If
        End If
    End If
    
    Exit Sub

ErrHandler:
    Call ErrorHandler("ExecuteSQLSafe")
End Sub

Private Function GetDbError(ByVal lo_Db As ARMSYSCOMLib.ArmDb) As String
On Error GoTo ErrHandler
    If IsArray(lo_Db.SQLErrorMessages) Then
        Debug.Assert (IsArray(lo_Db.SQLErrorCodes))
        ' Display errors msgBox
        GetDbError = Join(lo_Db.SQLErrorCodes, ",") & vbCrLf & Join(lo_Db.SQLErrorMessages, vbCrLf)
    Else
        ' ExecuteSQL failed but no error message?
        GetDbError = "Unknown error"
    End If
    Exit Function
ErrHandler:
    Call ErrorHandler("GetDbError()")
End Function

Private Function GetArrayValue(ByRef ao_variantArray As Variant, ByVal al_Index As Long) As Variant
    If IsArray(ao_variantArray) Then
        If UBound(ao_variantArray) <= al_Index Then
            GetArrayValue = ao_variantArray(al_Index)
        Else
            GetArrayValue = 0
        End If
    Else
        GetArrayValue = 0
    End If
End Function



